<?php
// Start the session at the top
session_start();

$htaccessFile = __DIR__ . '/.htaccess';

// Check if the .htaccess file exists and contains database configuration details
if (file_exists($htaccessFile)) {
    $htaccessContent = file_get_contents($htaccessFile);

    // Check if required database details and BASEURL are present in the .htaccess file
    if (strpos($htaccessContent, 'SetEnv DB_SERVER') !== false && 
        strpos($htaccessContent, 'SetEnv DB_USERNAME') !== false && 
        strpos($htaccessContent, 'SetEnv DB_PASSWORD') !== false && 
        strpos($htaccessContent, 'SetEnv DB_NAME') !== false &&
        strpos($htaccessContent, 'SetEnv BASE_URL') !== false) {
        
        // If DB details and BASEURL are found, redirect the user based on session
        if (isset($_SESSION['user'])) {
            // Redirect to the dashboard
            header('Location: ./pages/dashboard.php');
            exit;
        } else {
            // Redirect to login page
            header('Location: ./auth/login.php');
            exit;
        }
    } else {
        // If DB details or BASEURL are missing, redirect to installer
        header('Location: ./config/installer.php');
        exit();
    }
} else {
    // If .htaccess doesn't exist, redirect to installer
    header('Location: ./config/installer.php');
    exit();
}
?>
